<?php declare(strict_types = 1);

namespace Core\Model\Pdf;

use Mpdf\Mpdf;
use Nette\Application\UI\ITemplateFactory;

class Pdf
{
	/** @var array */
	protected $mPdfConfigDefaults = [
		'tempDir' => TMP_DIR . '/mPdf',
	];

	/** @var array */
	protected $mPdfConfig;

	/** @var ITemplateFactory */
	protected $templateFactory;

	public function __construct($mPdfConfig, ITemplateFactory $templateFactory)
	{
		$this->mPdfConfig      = array_merge($this->mPdfConfigDefaults, $mPdfConfig) ?: [];
		$this->templateFactory = $templateFactory;
	}

	public function newPdf(array $customConfig = [])
	{
		$this->mPdfConfig = $customConfig + $this->mPdfConfig;

		if (isset($this->mPdfConfig['fontDir'])) {
			$defaultConfig = (new \Mpdf\Config\ConfigVariables())->getDefaults();
			$fontDirs      = $this->mPdfConfig['disableBaseFontDir'] ? [] : $defaultConfig['fontDir'];

			$this->mPdfConfig['fontDir'] = array_merge($fontDirs, $this->mPdfConfig['fontDir']);
		}

		if (isset($this->mPdfConfig['fontData'])) {
			$defaultFontConfig = (new \Mpdf\Config\FontVariables())->getDefaults();
			$fontData          = $this->mPdfConfig['disableBaseFontData'] ? [] : $defaultFontConfig['fontdata'];

			$this->mPdfConfig['fontdata'] = $fontData + $this->mPdfConfig['fontData'];
			unset($this->mPdfConfig['fontData']);
		}

		$mpdf = new Mpdf($this->mPdfConfig);

		return $mpdf;
	}

	public function getTemplateFactory()
	{
		$latte = $this->templateFactory->createTemplate();

		return $latte;
	}
}
