<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

abstract class TemplateTextType
{
	/** @var string */
	protected $type;

	/** @var string */
	protected $name;

	/** @var string */
	protected $title;

	/** @var mixed */
	protected $default;

	/** @var string */
	protected $wrapEl = 'div class=form-group';

	/** @var string */
	protected $labelEl = 'label';

	/** @var string */
	protected $inputClass = 'form-control';

	/**
	 * @return string
	 */
	public function getType() { return $this->type; }

	/**
	 * @param string $title
	 */
	public function setTitle($title)
	{
		$this->title = $title;
	}

	/**
	 * @return string
	 */
	public function getTitle() { return $this->title; }

	/**
	 * @param string $name
	 */
	public function setName($name)
	{
		$this->name = $name;
	}

	/**
	 * @return string
	 */
	public function getName() { return $this->name; }

	/**
	 * @param mixed $default
	 * @return void
	 */
	public function setDefault($default)
	{
		$this->default = $default;
	}

	/**
	 * @return mixed
	 */
	public function getDefault() { return $this->default; }
}