<?php declare(strict_types = 1);

namespace Core\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Color extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'color';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$c = $formContainer->addColorInput($this->getName(), $this->getTitle());
		if (isset($params['multiLang']))
			$c->setIsMultilanguage($params['multiLang']);
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}
