<?php declare(strict_types = 1);

namespace Core\Model\Templating;

use Core\Model\UI\AbstractPresenter;
use Core\Model\UI\BaseControl;
use Nette\Application\LinkGenerator;
use Nette\Application\UI\Control;
use Nette\Bridges\ApplicationLatte\Template as NTemplate;
use Nette\InvalidStateException;
use Nette\Utils\Arrays;
use Users\Model\Security\User;

/**
 * @method bool isLinkCurrent(string $destination = null, $args = [])
 * @method bool isModuleCurrent(string $module)
 */
class Template extends NTemplate
{
	public User $user;
	public string $baseUrl;
	public string $basePath;
	public string $lang;
	/** @var Control|BaseControl */
	public $control;
	public AbstractPresenter $presenter;
	public LinkGenerator $linkGenerator;
	/** @var string[] */
	public array $flashes;

	/**
	 * @param mixed $value
	 */
	public function add(string $name, $value): Template
	{
		if (property_exists($this, $name)) {
			throw new InvalidStateException("The variable '$name' already exists.");
		}

		$this->$name = $value;
		return $this;
	}

	public function setParameters(array $params): Template
	{
		return Arrays::toObject($params, $this);
	}

}