<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Status;

use Core\Model\UI\DataGrid\Column;
use Ublaboo;

class Option extends Ublaboo\DataGrid\Status\Option
{
	/** @var bool */
	protected $showTitle = true;

	/**
	 * @var Column\ColumnStatus
	 */
	protected $columnStatus;

	/**
	 * @param Column\ColumnStatus $columnStatus
	 * @param mixed               $value
	 * @param string              $text
	 */
	public function __construct(Column\ColumnStatus $columnStatus, $value, $text)
	{
		$this->columnStatus = $columnStatus;
		$this->value        = $value;
		$this->text         = (string) $text;
	}

	/**
	 * End option fluent interface and return parent
	 */
	public function endOption(): Column\ColumnStatus
	{
		return $this->columnStatus;
	}

	/*******************************************************************************************************************
	 * ==========================  Setters
	 */

	public function setShowTitle($show = true): self
	{
		$this->showTitle = $show;

		return $this;
	}

	/*******************************************************************************************************************
	 * ==========================  Getters
	 */

	public function getShowTitle() { return $this->showTitle; }
}
