<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Gallery\AdminModule\Components\Image\IImagesZoneFactory;
use Gallery\AdminModule\Components\Image\ImagesZone;
use Gallery\Model\Entities\Album;
use Nette;
use Nette\Utils\Html;
use Nette\Application\UI\ISignalReceiver;
use Core\Model\UI\Form\Traits\ComponentControlTrait;

class GalleryPopupInput extends HiddenInput implements ISignalReceiver
{
	use ComponentControlTrait {
		attached as componentControlAttached;
	}

	/** @var array */
	protected $values = [];

	/** @var IImagesZoneFactory */
	protected $imagesZoneFactory;

	/** @var ImagesZone */
	protected $imagesZone;

	/** @var Nette\Http\Request */
	protected $httpRequest;

	protected $componentName;

	public function __construct($label = null, $imagesZoneFactory, Nette\Http\Request $request)
	{
		parent::__construct();
		$this->caption           = $label;
		$this->imagesZoneFactory = $imagesZoneFactory;
		$this->httpRequest       = $request;
	}

	protected function attached($component): void
	{
		parent::attached($component);
		if (!$this->form->getComponent($this->getName() . 'Gallery', false))
			$this->form->addComponent($this->getImagesZone(), $this->getName() . 'Gallery');
		$this->componentName = $this->getName() . 'Gallery';
		$this->componentControlAttached($component);
	}

	public function getControl(): Html
	{
		$control = Html::el();
		if ($this->getValue()) {
			$link = $this->link('showGallery', $this->getValue());
		} else {
			$link = $this->link('showGallery');
		}
		$button = Html::el('a class="btn btn-info ajax"', ['href' => $link])
			->setText($this->translate('gallery.galleryPopupInput.editGallery'));

		$control->addHtml('<label>' . $this->caption . '</label><br>');
		$control->addHtml($button);
		$control->addHtml(parent::getControl());

		return $control;
	}

	public function handleShowGallery()
	{
		$imagesZone = $this->getImagesZone();

		if ($this->getValue())
			$this->getImagesZone()->setAlbum($this->getValue());
		$this->getPresenter()->getTemplate()->modal            = 'test';
		$this->getPresenter()->getTemplate()->modalDialogClass = 'modal-full';
		ob_start();
		$imagesZone->render();
		$body                                           = ob_get_clean();
		$this->getPresenter()->getTemplate()->modalBody = Html::el()->addHtml($body);
		$this->getPresenter()->redrawControl('modal');
	}

	public function setDefaultValue($values)
	{
		$form = $this->getForm(false);
		if ($this->isDisabled() || !$form || !$form->isAnchored() || !$form->isSubmitted()) {
			$this->values = $values;
		}

		return $this;
	}

	protected function getImagesZone()
	{
		if (!$this->imagesZone) {
			$control = $this->imagesZoneFactory->create();

			$control->onEmpty[] = function($control) {
				/** @var ImagesZone $control */
				if (!$this->getValue()) {
					$form  = $this->getForm(false);
					$album = new Album(UPLOADS_PATH . '/template_pages/page_gallery');

					if ($form && isset($form['title'])) {
						$album->title = $form['title']->getValue() ?: ($control->data['title'] ?? '');
					}

					$control->getEm()->persist($album)->flush();

					$control->setAlbum($album->getId());
					$control->extendedResponseOnEmpty['setValueByHtmlName'][$this->getHtmlName()] = $album->getId();
					$control->extendedResponse['setValueByHtmlName'][$this->getHtmlName()]        = $album->getId();
					$this->value                                                                  = $album->getId();
				}
			};

			if ($this->getValue()) {
				$control->setAlbum($this->getValue());
			}

			$this->imagesZone = $control;
		}

		return $this->imagesZone;
	}

	public function getIsMultiLanguage() { return false; }

	/*******************************************************************************************************************
	 * ======================== REGISTER
	 */

	/**
	 * @param Nette\DI\Container $systemContainer
	 */
	public static function register(Nette\DI\Container $systemContainer)
	{
		$class = __CLASS__;
		Nette\Forms\Container::extensionMethod('addGalleryPopup', function(
			Nette\Forms\Container $container, $name, $caption
		) use ($class, $systemContainer) {
			/** @var GalleryPopupInput $comp */
			$comp = new $class($caption,
				$systemContainer->getService('gallery.admin.imagesZoneFactory'),
				$systemContainer->getByType(Nette\Http\Request::class, false));

			$container->addComponent($comp, $name);

			return $comp;
		});
	}
}
