<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Iterator;
use Nette\Forms\Form;

/**
 * Class SaveCancelControl
 * @package Core\Model\UI\Form\Controls
 */
class SaveCancelControl extends BaseContainer
{
	/**
	 * @var bool
	 */
	protected $floating = false;

	public bool $showOnlySave = false;

	/**
	 * SaveCancelControl constructor.
	 *
	 * @param string|null $saveCaption
	 * @param string|null $saveAndCloseCaption
	 * @param string|null $cancelCaption
	 */
	public function __construct($saveCaption = null, $saveAndCloseCaption = null, $cancelCaption = null)
	{
		$this->addSubmit('save', $saveCaption ?: 'default.save')
			->getControlPrototype()->addHtml('<i class="fa fa-save"></i>');
		$this->addSubmit('saveAndClose', $saveAndCloseCaption ?: 'default.saveAndClose')
			->getControlPrototype()->addHtml('<i class="fa fa-check"></i>');
		$this->addCancel('cancel', $cancelCaption ?: 'default.cancel')
			->setHtmlAttribute('type', 'button')
			->setHtmlAttribute('onclick', 'window.history.go(-1);')
			->setValidationScope([])
			->getControlPrototype()->addHtml('<i class="fa fa-times"></i>');
	}

	/**
	 * @return Iterator
	 */
	public function getControls(): Iterator
	{
		if ($this->showOnlySave) {
			$this->removeComponent($this->getComponent('saveAndClose'));
			$this->removeComponent($this->getComponent('cancel'));
		}

		if ($this->getForm()->onCancel) {
			$this['cancel']->setHtmlAttribute('type', 'submit');
			$this['cancel']->setHtmlAttribute('onclick', null);
		}

		return parent::getControls();
	}

	public function setFloating($value = true)
	{
		$this->floating = $value;
	}

	/**
	 * @return bool
	 */
	public function isFloating(): bool
	{
		return $this->floating;
	}

	/**
	 * @param bool $throw
	 *
	 * @return \Nette\Forms\Form|BaseForm|null
	 */
	public function getForm($throw = true): Form
	{
		return parent::getForm($throw);
	}

	public function closeModalOnCancel()
	{
		$this['cancel']->setHtmlAttribute('onclick', 'closeModal("' . $this['cancel']->getHtmlId() . '");');
	}
}
