<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\ComponentControlTrait;
use Nette;
use Nette\Application\UI\ISignalReceiver;
use Nette\Utils\Html;

class TagsInput extends TextInput implements ISignalReceiver
{
	use ComponentControlTrait {
		attached as componentControlAttached;
	}

	/** @var array */
	protected $values = [];

	/** @var Nette\Utils\Callback */
	protected $callback;

	/** @var Nette\Utils\Callback */
	protected $createCallback;

	public function __construct($label = null, string $callback = null, string $createCallback = null)
	{
		parent::__construct($label);
		$this->setCallback($callback);
		$this->setCreateCallback($createCallback);
	}

	public function getControl(): Html
	{
		$control          = parent::getControl();
		$control->class[] = 'form-control form-control-lg';
		$control->attrs   += [
			'data-role'     => 'tagsinput',
			'data-defaults' => Nette\Utils\Json::encode($this->values),
		];
		if (!empty($this->placeholder)) {
			$control->setAttribute('placeholder', $this->placeholder);
		}

		return $control;
	}

	protected function attached($component): void
	{
		parent::attached($component);
		$this->componentControlAttached($component);
		if ($component instanceof Nette\Application\IPresenter) {
			$this->control->{'data-typeahead-url'} = $this->callback;
			$this->control->{'data-create-url'}    = $this->createCallback;
		}
	}

	public function setCallback($callback)
	{
		$this->callback = $callback;
	}

	public function setCreateCallback($callback)
	{
		$this->createCallback = $callback;
	}

	public function setDefaultValue($values)
	{
		$form = $this->getForm(false);
		if ($this->isDisabled() || !$form || !$form->isAnchored() || !$form->isSubmitted()) {
			$this->values = $values;
			$this->setValue(implode(',', array_map(function($v) { return $v['key']; }, $values)));
		}

		return $this;
	}

}
