<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Core\Model\Module;
use Nette\Forms\Helpers;
use Nette\Utils\Html;
use Nette\Utils\Json;

/**
 * Trait TInputExtend
 * @package Core\Model\UI\Form\Traits
 */
trait TInputExtend
{
	/** @var string */
	public $description;

	/** @var bool */
	public $isMultiLanguage = false;

	/**
	 * @param $description
	 *
	 * @return $this
	 */
	public function setDescription($description)
	{
		$this->description = $description;

		return $this;
	}

	public function getLabel($caption = null): Html
	{
		$label = parent::getLabel($caption);

		if (Module::isAdmin()) {
			$langsCount = count($this->getForm()->langsService->getLangs(false));
			$wrap       = Html::el('div class="label-wrap"');

			if ($this->getIsMultiLanguage() && $langsCount > 1) {
				$wrap->addHtml(Html::el('i class="flag-icon"'));
				$wrap->addHtml($label);

				return $wrap;
			} else if ($this->getForm()->getShowLangSwitcher() && $langsCount > 1) {
				$wrap->addHtml(Html::el('i class="fas fa-globe"'));
				$wrap->addHtml($label);

				return $wrap;
			}
		}

		return $label;
	}

	/**
	 * @param bool $val
	 *
	 * @return $this
	 */
	public function setIsMultilanguage($val = true)
	{
		$this->isMultiLanguage = $val;

		return $this;
	}

	/**
	 * @return mixed
	 */
	public function getDescription() { return $this->getTranslator()->translate($this->description); }

	public function getIsMultiLanguage() { return $this->getForm(false)->langsService && $this->isMultiLanguage; }

	protected function createTranslatableControl($control)
	{
		if ($this->getIsMultiLanguage()) {
			$wrap        = Html::el('div');
			$langs       = $this->getForm()->langsService->getLangs();
			$defaultLang = array_shift($langs);
			foreach ($langs as $k => $lang) {
				$c = clone $control;

				// TODO předělat a upravit taky aby bylo povinné pouze jedno pole
				if ($defaultLang->getTag() != $lang->getTag()) {
					unset($c->attrs['required']);

					foreach ($c->attrs['data-nette-rules'] as $k2 => $rule) {
						if ($rule['op'] == ':filled')
							unset($c->attrs['data-nette-rules'][$k2]);
						break;
					}
				}

				if (isset($this->placeholder) && !empty($this->placeholder))
					$c->attrs['placeholder'] = $this->placeholder[$lang->getTag()];

				$c->attrs['name']              .= "[$k]";
				$c->attrs['id']                .= "-$k";
				$c->attrs['data-content-lang'] = $k;

				$getValue = $this->getValue();
				$value    = (is_array($getValue) ? $getValue[$k] : $getValue->$k) ?? '';

				if ($c->getName() == 'textarea')
					$c->setText($value);
				else
					$c->attrs['value'] = $value;

				$wrap->addHtml($c);
			}

			return $wrap;
		}

		return $control;
	}

	/**
	 * Loads HTTP data.
	 * @return mixed
	 */
	protected function getHttpData($type, $htmlTail = null)
	{
		if ($this->getIsMultiLanguage())
			return array_map(function($lang) use ($type, $htmlTail) {
				return $this->getForm()->getHttpData($type, $this->getHtmlName() . "[{$lang->getTag()}]" . $htmlTail);
			}, $this->getForm()->langsService->getLangs(false));
		else
			return $this->getForm()->getHttpData($type, $this->getHtmlName() . $htmlTail);
	}

	public function getAttrRules(): array
	{
		return Helpers::exportRules($this->getRules()) ?: [];
	}

	public function getAttrRulesJson(): string { return Json::encode($this->getAttrRules()); }
}
