const appState                             = require("./webpack.appState");
const path                                 = require('path');
const {readdirSync, lstatSync, existsSync} = require('fs');

/**
 * Main function for dynamically defining the entry points
 * Finds all js enrtypoints in baseJsFolder path
 * @param generalScriptFilePath general script file path
 * @param generalScssFilePath template.scss with all other partial styles imported
 * @param baseJsFolder base folder of js entrypoints (scripts intended for individual pages)
 * @returns {{script: *[]}}
 */

module.exports = {
	getDynamicEntryPoints(baseScssFolder, baseJsFolder) {
		const config = {
			base: [],
		};

		console.clear();
		console.log('\x1b[31m', 'Application assets (scss/js):', '\x1b[0m');

		// Přidání hlavního sdileneho souboru pro scss
		// PRAVIDLO POUZE PRO MULTISHOP
		let baseScssFile = baseScssFolder + 'generalTemplate/template.scss';
		if (existsSync(baseScssFile)) {
			config.base.push(baseScssFile);

			console.log(' Base scss file: ' + baseScssFile);
		}

		// Prohledání složek pro scss více webů
		let scssFolders = readdirSync(baseScssFolder).filter(name => lstatSync(baseScssFolder + name).isDirectory() === true && appState.sites.includes(name) === true);
		scssFolders.forEach(scssFolder => {
			const scssFile = baseScssFolder + scssFolder + '/template.scss';

			if (!existsSync(scssFile)) {
				return;
			}

			config[scssFolder] = [scssFile];
			console.log(' Site scss file: ' + scssFile);
		});

		// Části šablon
		const baseScssTemplatePartsFolder = baseScssFolder + 'templateParts/';
		if (existsSync(baseScssTemplatePartsFolder)) {
			let scssFoldersParts = readdirSync(baseScssTemplatePartsFolder).filter(name => lstatSync(baseScssTemplatePartsFolder + name).isDirectory() === true);
			scssFoldersParts.forEach(scssFolder => {
				const scssFile = baseScssTemplatePartsFolder + scssFolder + '/template.scss';

				if (!existsSync(scssFile)) {
					return;
				}

				config['part_' + scssFolder] = [scssFile];
				console.log(' Part scss file: ' + 'part_' + scssFile);
			});
		}

		// Prohledání hlavní složky js assetů
		let jsFiles = readdirSync(baseJsFolder).filter(file => lstatSync(baseJsFolder + file).isDirectory() === false);
		jsFiles.forEach(jsFileName => {
			const name   = path.parse(jsFileName).name;
			const jsFile = baseJsFolder + jsFileName;

			if (!existsSync(jsFile)) {
				return;
			}

			config[name] = [jsFile];
			console.log(' Base js file: ' + jsFile);
		});

		// Prohledání složek pro js více webů a přidání do seznamu js assetů
		let jsFolders = readdirSync(baseJsFolder).filter(name => lstatSync(baseJsFolder + name).isDirectory() === true && appState.sites.includes(name) === true);
		jsFolders.forEach(jsFolder => {
			let list = readdirSync(baseJsFolder + jsFolder).map(file => baseJsFolder + jsFolder + '/' + file).filter(file => lstatSync(file).isDirectory() === false);

			list.forEach(jsFile => {
				const name = path.parse(jsFile).name;

				config[jsFolder + '/' + name] = [jsFile];
				console.log(' Site js file: ' + jsFile);
			});
		});

		//Fancybox
		if (existsSync(path.resolve(appState.rootDir + '/node_modules/@fancyapps/ui'))) {
			appState.useFancyBoxV4  = true;
			config['core/fancybox'] = [
				path.resolve(appState.rootDir + '/vendor/pshkcms/core/assets/front/src/js/libs/fancybox.js'),
				path.resolve(appState.rootDir + '/vendor/pshkcms/core/assets/front/src/scss/libs/fancybox.scss'),
			];
		}

		if (config.base.length === 0) {
			delete config.base;
		}

		return config;
	},

	getCmsPackagesWithFrontAssets(baseFolder, returnKey) {
		const packages = readdirSync(baseFolder).filter(name => {
			return existsSync(path.join(baseFolder, name, 'assets', 'front'));
		}).map(name => path.join(baseFolder, name));

		if (packages.length > 0) {
			console.log('\x1b[31m', `Packages (${returnKey}) with assets folder:`, '\x1b[0m');
			packages.forEach(pack => {
				const key = path.parse(pack).name;
				console.log(" " + key);
			});
		}

		return {[returnKey]: packages};
	},

	loadBaseFromPackage(entry, dir) {
		let packageName = path.parse(dir).name;
		let scss        = `${dir}/assets/front/src/scss/style.scss`;
		let js          = `${dir}/assets/front/src/js/index.js`;

		entry[packageName]                              = [];
		appState.aliasses[path.parse(packageName).base] = path.resolve(__dirname, `${dir}/assets/front/src`);

		if (existsSync(scss)) {
			entry[packageName].push(scss);
		}
		if (existsSync(js)) {
			entry[packageName].push(js);
		}

		if (entry[packageName].length === 0) {
			delete entry[packageName];
		}

		// Ostatni assety
		let assetsDir = path.resolve(dir + '/assets/front/src/js');
		if (!existsSync(assetsDir)) {
			return true;
		}

		let jsFiles = readdirSync(assetsDir).filter(file => file !== 'index.js' && path.parse(assetsDir + '/' + file).ext === '.js');
		jsFiles.forEach(file => {
			file     = path.resolve(assetsDir + '/' + file);
			let name = path.parse(file).name;

			if (!existsSync(file)) {
				return true;
			}

			entry[packageName + '/' + name] = [file];
		});

		const customConfigFile = path.resolve(dir + `/webpack.frontConfig.js`);
		if (existsSync(customConfigFile)) {
			const customConfig = require(customConfigFile);
			customConfig.updateFrontEntries(entry);
		}

		return entry;
	},
};
