import path                      from 'path'
import {existsSync, readdirSync} from "fs";
import {fileURLToPath}           from 'url';
import {dirname}                 from 'path';

const __filename = fileURLToPath(import.meta.url);
const __dirname  = dirname(__filename);

const vendorBaseFolder = path.resolve(__dirname, '../../');

const getDefaultJsFiles = (moduleDir) => {
	const list       = {};
	const moduleName = path.basename(moduleDir);
	const jsDir      = path.resolve(moduleDir, 'assets', 'front', 'src', 'js');

	let jsFiles = readdirSync(jsDir).filter(file => file !== 'index.js' && path.parse(jsDir + '/' + file).ext === '.js');
	jsFiles.forEach(file => {
		file     = path.resolve(jsDir + '/' + file);
		let name = path.parse(file).name;

		list[moduleName + '/' + name] = file;
	});

	return list;
}

export {
	vendorBaseFolder,
	getDefaultJsFiles,
}
