const TerserJSPlugin     = require("terser-webpack-plugin");
const CssMinimizerPlugin = require("css-minimizer-webpack-plugin");
const path               = require("path");

module.exports = {
	rootDir      : path.resolve(__dirname, '../../../../'),
	sites        : [],
	aliasses     : {},
	useFancyBoxV4: false,
	cacheGroups  : {
		baseLibs: {
			test   : /[\\/]node_modules[\\/](naja|es6-slide-up-down|formatMoney|utilities)[\\/]/,
			name   : 'baseLibs',
			chunks : 'all',
			minSize: 0,
		},
		tns     : {
			test   : /[\\/]node_modules[\\/](tiny-slider)[\\/]/,
			name   : 'tns',
			chunks : 'all',
			minSize: 0,
		}
	},
	minimizer    : {
		'terser'      : new TerserJSPlugin({
			parallel       : true,
			extractComments: false,
		}),
		'cssMinimizer': new CssMinimizerPlugin({
			minimizerOptions: {
				preset: [
					'default',
					{
						discardComments: {removeAll: true},
					},
				],
			},
		}),
	}
}
