import {vendorBaseFolder, getDefaultJsFiles} from './../core/utils/viteUtils.mjs'
import {fileURLToPath}                       from "url";
import path                                  from "path";

const __filename = fileURLToPath(import.meta.url);
const __dirname  = path.dirname(__filename);

export default {
	resolve: {
		alias: {
			'~core': path.resolve(__dirname, 'assets', 'front', 'src'),
		},
	},
	build  : {
		rollupOptions: {
			external: [
				/^pnotify.*/,
			]
		},
		lib          : {
			entry: {
				...getDefaultJsFiles(__dirname),
			}
		}
	}
}
