import {existsSync, readdirSync} from "fs";
import path from "path";
import merge from "ts-deepmerge";
import auto from '@rollup/plugin-auto-install';
import resolve from '@rollup/plugin-node-resolve';

const vendorBaseFolder = path.resolve(__dirname, '..');
const projectDir = path.resolve(__dirname, '../../../');

const loadPackagesConfig = async () => {
	let config = {};

	const packages = readdirSync(vendorBaseFolder)

	await Promise.all(packages.map(async (name) => {
		const packageConfigFile = path.resolve(vendorBaseFolder, name, 'vite.front.mjs');
		if (existsSync(packageConfigFile)) {
			const {default: moduleDefault} = await import('./vendor/pshkcms/' + name + '/vite.front.mjs');

			config = merge(config, moduleDefault);
		}
	}));

	return config
}

let config = {
	root: path.resolve(projectDir, 'www'),
	cacheDir: 'assets/front/cache',
	build: {
		emptyOutDir: false,
		outDir: 'assets/front/dist',
		sourcemap: true,
		cssCodeSplit: true,
		rollupOptions: {
			output: {
				assetFileNames: '[name].[ext]',
			},
			external: []
		},
		lib: {
			entry: {
				script: path.resolve(projectDir, 'www/assets/front/src/js/script.js'),
				template: path.resolve(projectDir, 'www/assets/front/src/scss/generalTemplate/template.scss'),
				bootstrap: path.resolve(projectDir, 'www/assets/front/src/scss/templateParts/bootstrap/template.scss'),
				eshopcatagory: path.resolve(projectDir, 'www/assets/front/src/scss/templateParts/eshopcategory/template.scss'),
			},
			formats: ["es", "cjs"],
		}
	},
	resolve: {
		extensions: ['.js', '.ts', '.scss', '.json'],
		alias: {
			'@': path.resolve(projectDir),
			'~bootstrap': path.resolve(projectDir, 'node_modules/bootstrap'),
		},
	},
	plugins: [auto(), resolve()]
};

export const getConfig = async () => {
	const data = await loadPackagesConfig();
	config = merge(config, data);

	return config;
}
