<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\WebColors\ColorsForm;
use Core\AdminModule\Components\WebColors\IColorsFormFactory;

class WebColorsPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings'))
			$this->error();

		$this->setHeader('admin.title.webColors', 'fas fa-palette');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	/*******************************************************************************************************************
	 * ===============================  Handle
	 */

	/*******************************************************************************************************************
	 * ===============================  Action
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentColorsForm(IColorsFormFactory $factory): ColorsForm
	{
		return $factory->create();
	}
}
