<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Column;

use Nette\Utils\Html;
use Ublaboo;
use Ublaboo\DataGrid\Row;

class Action extends Ublaboo\DataGrid\Column\Action
{
	protected $class  = 'btn btn-xs';
	protected $bsType = 'secondary';

	public function render(Row $row)
	{
		$html = parent::render($row);

		if ($html instanceof Html)
			$html->class .= ' btn-' . $this->bsType;

		return $html;
	}

	public function addClass($class)
	{
		$this->class .= ' ' . $class;

		return $this;
	}

	/*******************************************************************************************************************
	 * ==========================  Setters
	 */
	public function setBsType($type = 'secondary')
	{
		$this->bsType = $type;

		return $this;
	}
}