<?php declare(strict_types = 1);

namespace Currency\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Currency\Model\Currencies;

class CurrencySwitch extends BaseControl
{
	/** @var Currencies @inject */
	public $currenciesService;

	public function render(): void
	{
		$this->template->currencies = $this->currenciesService->getActive();
		$this->template->render($this->getTemplateFile());
	}

	public function handleSwitch(int $id)
	{
		$this->currenciesService->setCurrentCurrency($id);

		$this->redirect('this');
	}
}
