<?php declare(strict_types = 1);

namespace Currency\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;
use Currency\Model\Exchange;
use EshopCatalog\FrontModule\Model\Event\ProductsEvent;
use EshopCatalog\FrontModule\Model\Products;

class ProductsSubscriber implements EventSubscriberInterface
{
	/** @var Exchange */
	protected $exchangeService;

	/** @var Currencies */
	protected $currenciesService;

	protected array $used = [];

	public function __construct(Exchange $exchange, Currencies $currencies)
	{
		$this->exchangeService   = $exchange;
		$this->currenciesService = $currencies;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			Products::class . '::afterLoadFresh' => ['afterLoadFresh', -10],
		];
	}

	public function afterLoadFresh(ProductsEvent $event): void
	{
		$currency = $this->currenciesService->getCurrent();

		foreach ($event->products as &$product) {
			if (in_array($product->getId(), $this->used))
				continue;

			$product->basePrice   = $this->exchangeService->change((float) $product->basePriceInBaseCurrency, $currency->getCode());
			$product->price       = $this->exchangeService->change((float) $product->priceInBaseCurrency, $currency->getCode());
			$product->retailPrice = $this->exchangeService->change((float) $product->retailPriceInBaseCurrency, $currency->getCode());
			$this->used[]         = $product->getId();
		}
	}
}
