<?php declare(strict_types = 1);

namespace Currency\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Core\Model\Http\Session;
use Core\Model\Sites;
use Core\Model\Templating\Filters\Price;
use Currency\Model\Entities\Currency;
use Nette\Http\SessionSection;

class Currencies extends BaseFrontEntityService
{
	/** @var string */
	protected $entityClass = Currency::class;

	/** @var Sites */
	protected $sitesService;

	/** @var SessionSection */
	protected $sessionSection;

	protected $cCurrent, $cAll, $cActive;

	public function __construct(Sites $sites, Session $session)
	{
		$this->sitesService   = $sites;
		$this->sessionSection = $session->getSection('currency');
	}

	public function getDefaultCode(): string { return (string) Config::load('default'); }

	/**
	 * @return Currency[]
	 */
	public function getActive(): array
	{
		if ($this->cActive === null) {
			$this->cActive = [];
			foreach ($this->getAll() as $currency) {
				if ($currency->isActive)
					$this->cActive[$currency->getCode()] = $currency;
			}
		}

		return $this->cActive;
	}

	/**
	 * @return Currency[]
	 */
	public function getAll(): array
	{
		if ($this->cAll === null) {
			$this->cAll = [];
			foreach ($this->getEr()->createQueryBuilder('c')
				         ->where('c.site = :currentSite OR c.site IS NULL')
				         ->setParameter('currentSite', $this->sitesService->getCurrentSite()->getIdent())
				         ->getQuery()->getResult() as $row) {
				/** @var Currency $row */
				if (isset($list[$row->getCode()]) && !$row->site)
					continue;

				$this->cAll[$row->getCode()] = $row;
			}
		}

		return $this->cAll;
	}

	public function getCurrent(): Currency
	{
		// TODO vychozi podle eshopu
		$defaultFromConfig  = Config::load('default');
		$all                = $this->getAll();
		$defaultFromSession = $this->sessionSection->current;
		$current            = null;

		foreach ($all as $c) {
			if ($c->getId() == $defaultFromSession)
				return $c;

			if ($c->getId() == $defaultFromConfig)
				$current = $c;
		}

		return $current ?: array_values($all)[0];
	}

	public function updatePriceFilter(Price $filter): void
	{
		if (strpos($_SERVER['REQUEST_URI'], '/admin') !== 0) {
			$currency = $this->getCurrent();

			$filter->setCurrencyFromLeft((bool) $currency->currencyFromLeft);
			$filter->setCurrency($currency->symbol);
			$filter->setDecimals($currency->decimals);
		}

		foreach ($this->getAll() as $currency) {
			$filter->addOtherCurrency($currency->getCode(), $currency->symbol, (bool) $currency->currencyFromLeft, $currency->decimals);
		}
	}

	public function setCurrentCurrency(int $id): void
	{
		$currency = $this->getEr()->find($id);

		if ($currency)
			$this->sessionSection->current = $id;
	}
}
