<?php declare(strict_types = 1);

namespace Currency\AdminModule\Model;

use Nette\Security\User;

class Security
{
	/** @var User */
	protected $user;

	const RESOURCE_CURRENCY = 'Currency:Admin';

	public function __construct(User $user)
	{
		$this->user = $user;
	}

	public function access(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'access');
	}

	public function new(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'new');
	}

	public function edit(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'edit');
	}

	public function delete(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'delete');
	}
}
