<?php declare(strict_types = 1);

namespace Currency\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;

class CurrencyExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Currency' => 'Currency\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(ClassType $class)
	{
		parent::afterCompile($class);

		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$init->addBody('$this->getService(\'currency.currencies\')->setDefaultCurrency();');
		$init->addBody('$this->getService(\'currency.currencies\')->setCurrencyByUrl();');
		$init->addBody('Core\Model\Templating\Filters\Price::$priceInitCallback[] = function($filter) { return $this->getService(\'currency.currencies\')->updatePriceFilter($filter); };');
		$init->addBody('Currency\Model\Config::setParams(?);', [$builder->parameters['currency']]);
	}
}
