<?php declare(strict_types = 1);

namespace Currency\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;
use Currency\Model\Exchange;
use Core\Model\Entities\EntityManagerDecorator;

class OrderSalesSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	protected Exchange $exchangeService;

	protected Currencies $currenciesService;

	public function __construct(EntityManagerDecorator $em, Exchange $exchange, Currencies $currencies)
	{
		$this->em                = $em;
		$this->exchangeService   = $exchange;
		$this->currenciesService = $currencies;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}
}
