<?php declare(strict_types = 1);

namespace Currency\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Currency\Model\Currencies;
use Nette\Http\Request;

class CurrencySwitch extends BaseControl
{
	/** @var Currencies|null @inject */
	public ?Currencies $currenciesService = null;

	/** @var Request|null @inject */
	public ?Request $httpRequest;

	public function render(): void
	{
		$this->template->buildUrl   = function(string $curr): string {
			$url = $this->httpRequest->getUrl();

			return $url->withQueryParameter('curr', $curr)->getAbsoluteUrl();
		};
		$this->template->currencies = $this->getActiveCurrencies();
		$this->template->render($this->getTemplateFile());
	}

	public function handleSwitch(): void
	{
		$this->redirect('this');
	}

	public function getActiveCurrencies()
	{
		return $this->currenciesService->getActive();
	}
}
