<?php declare(strict_types = 1);

namespace Currency\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;
use Currency\Model\Exchange;
use EshopSales\FrontModule\Model\Event\OrderSalesEvent;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\Model\Entities\OrderSale;
use Core\Model\Entities\EntityManagerDecorator;

class OrderSalesSubscriber implements EventSubscriberInterface
{
	/** @var EntityManagerDecorator */
	protected $em;

	/** @var Exchange */
	protected $exchangeService;

	/** @var Currencies */
	protected $currenciesService;

	public function __construct(EntityManagerDecorator $em, Exchange $exchange, Currencies $currencies)
	{
		$this->em                = $em;
		$this->exchangeService   = $exchange;
		$this->currenciesService = $currencies;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			OrderSales::class . '::fillDao' => ['fillDao', -10],
		];
	}

	public function fillDao(OrderSalesEvent $event): void
	{
		$currencyCode = $this->currenciesService->getCurrent()->getCode();

		foreach ($event->orderSales as $k => &$orderSale) {
			$orderSale->fromPrice = $this->exchangeService->change($orderSale->fromPriceInBaseCurrency, $currencyCode);

			if ($orderSale->type === OrderSale::TYPE_FIX)
				$orderSale->value = $this->exchangeService->change($orderSale->valueInBaseCurrency, $currencyCode);
		}
	}
}
