<?php declare(strict_types = 1);

namespace Currency\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;
use Currency\Model\Exchange;
use EshopCatalog\FrontModule\Model\Event\ProductsEvent;
use EshopCatalog\FrontModule\Model\Products;

class ProductsSubscriber implements EventSubscriberInterface
{
	/** @var Exchange */
	protected $exchangeService;

	/** @var Currencies */
	protected $currenciesService;

	public static array $used = [];

	public function __construct(Exchange $exchange, Currencies $currencies)
	{
		$this->exchangeService   = $exchange;
		$this->currenciesService = $currencies;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			Products::class . '::afterLoadFresh' => ['afterLoadFresh', -10],
		];
	}

	public function afterLoadFresh(ProductsEvent $event): void
	{
		$currency        = $this->currenciesService->getCurrent();
		$defaultCurrency = $this->currenciesService->getAll()[$this->currenciesService->getDefaultCode()] ?? null;
		$decimals        = $defaultCurrency ? (int) $defaultCurrency->decimals : 0;

		foreach ($event->products as &$product) {
			if (in_array($product->getId(), self::$used))
				continue;

			$product->basePriceInBaseCurrency   = round($product->basePriceInBaseCurrency, $decimals);
			$product->priceInBaseCurrency       = round($product->priceInBaseCurrency, $decimals);
			$product->retailPriceInBaseCurrency = round($product->retailPriceInBaseCurrency, $decimals);

			if ($product->currency && $product->currency !== $defaultCurrency->getCode()) {
				$product->basePriceInBaseCurrency   = $this->exchangeService->change($product->basePriceInBaseCurrency, $defaultCurrency->getCode(), $product->currency);
				$product->priceInBaseCurrency       = $this->exchangeService->change($product->priceInBaseCurrency, $defaultCurrency->getCode(), $product->currency);
				$product->retailPriceInBaseCurrency = $this->exchangeService->change($product->retailPriceInBaseCurrency, $defaultCurrency->getCode(), $product->currency);
			}

			$product->basePrice   = $this->exchangeService->change((float) $product->basePriceInBaseCurrency, $currency->getCode());
			$product->price       = $this->exchangeService->change((float) $product->priceInBaseCurrency, $currency->getCode());
			$product->retailPrice = $this->exchangeService->change((float) $product->retailPriceInBaseCurrency, $currency->getCode());
			self::$used[]         = $product->getId();
		}
	}
}
