<?php declare(strict_types = 1);

namespace Currency\Model\Entities;

use Core\Model\Entities\Country;
use Core\Model\Entities\Site;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("currency__currency")
 * @ORM\Entity
 * @ORM\EntityListeners({"Currency\Model\Listeners\CurrencyListener"})
 */
class Currency
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="code", type="string", length=3, nullable=false)
	 */
	private $code;

	/**
	 * @var string
	 * @ORM\Column(name="symbol", type="string", length=10, nullable=false)
	 */
	public $symbol;

	/**
	 * @var Country
	 * @ORM\OneToOne(targetEntity="Core\Model\Entities\Country")
	 * @ORM\JoinColumn(referencedColumnName="id", name="country", nullable=true, onDelete="SET NULL")
	 */
	public $country;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="native_title", type="string", nullable=false)
	 */
	public $nativeTitle;

	/**
	 * @var float
	 * @ORM\Column(name="home", type="decimal", precision=10, scale=3, nullable=false)
	 */
	public $home;

	/**
	 * @var float
	 * @ORM\Column(name="rate", type="decimal", precision=10, scale=3, nullable=false)
	 */
	public $rate;

	/**
	$init->addBody('Currency\Model\Config::setParams(?);', [$builder->parameters['currency']]);
	 * @var DateTime
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(type="datetime")
	 */
	private $updated;

	/**
	 * @var CurrencyHistory[]
	 * @ORM\OneToMany(targetEntity="CurrencyHistory", mappedBy="currency", orphanRemoval=true)
	 * @ORM\OrderBy({"created"="DESC"})
	 */
	private $history;

	/**
	 * @var boolean
	 * @ORM\Column(name="sync", type="boolean", nullable=true, options={"default": false})
	 */
	public $sync;

	/**
	 * @var string
	 * @ORM\Column(name="sync_key", type="string", nullable=true)
	 */
	public $syncKey;

	/**
	 * @var Site
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", nullable=true, onDelete="SET NULL")
	 */
	public $site;

	/**
	 * @var int
	 * @ORM\Column(name="currency_from_left", type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public $currencyFromLeft;

	/**
	 * @var int
	 * @ORM\Column(name="decimals", type="integer", nullable=false, options={"default": 0})
	 */
	public $decimals;

	/**
	 * @var int
	 * @ORM\Column(name="is_active", type="smallint", nullable=false, options={"default": 1})
	 */
	public $isActive;

	public function __construct(string $code, string $title, string $symbol, float $home, float $rate)
	{
		$this->code             = $code;
		$this->title            = $title;
		$this->symbol           = $symbol;
		$this->home             = $home;
		$this->rate             = $rate;
		$this->sync             = false;
		$this->history          = new ArrayCollection();
		$this->currencyFromLeft = 0;
		$this->decimals         = 0;
		$this->isActive         = 1;
	}

	public function getCode(): string { return $this->code; }

	public function getUpdated(): DateTime { return $this->updated; }

	public function getHistory() { return $this->history; }
}
