<?php declare(strict_types = 1);

namespace Currency\FrontModule\Model\Subscribers;

use Core\Model\Entities\EntityManagerDecorator;
use Currency\Model\Config;
use Currency\Model\Currencies;
use Currency\Model\Entities\Currency;
use Currency\Model\Exchange;
use EshopOrders\FrontModule\Model\Dao\Discount;
use EshopOrders\FrontModule\Model\Event\FillDaoItemsEvent;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSalesSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Exchange               $exchangeService,
		protected Currencies             $currenciesService,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.cartSetDiscounts' => 'cartSetDiscounts',
		];
	}

	public function cartSetDiscounts(FillDaoItemsEvent $event): void
	{
		if (!$event->items) {
			return;
		}

		$currency = $this->currenciesService->getCurrent();
		if (!$currency instanceof Currency) {
			return;
		}

		$defaultCurrency = $this->currenciesService->getDefaultCode();

		foreach ($event->items as &$item) {
			/** @var Discount $item */
			$item->discountInBaseCurrency = $this->exchangeService->change($item->discount, $defaultCurrency, $currency->getCode());

			if (Config::load('roundOrderSales')) {
				$item->discount = round($item->discount);
			}
		}
	}
}
