<?php declare(strict_types = 1);

namespace Currency\Model\Entities;

use DateTime;
use Core\Model\Entities\TId;
use Core\Model\Helpers\Strings;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('currency__currency_history')]
#[ORM\Entity]
class CurrencyHistory
{
	use TId;

	#[ORM\JoinColumn(name: 'currency_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Currency::class, inversedBy: 'history')]
	private Currency $currency;

	/**
	 * @var float|string
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 3, nullable: false)]
	private $home;

	/**
	 * @var float|string
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 3, nullable: false)]
	private $rate;

	#[ORM\Column(type: Types::DATETIME_MUTABLE)]
	private DateTime $created;

	public function __construct(Currency $currency, ?float $home = null, ?float $rate = null, ?DateTime $created = null)
	{
		$this->currency = $currency;
		$this->home     = $home ?: $currency->home;
		$this->rate     = Strings::formatEntityDecimal($rate ?: $currency->rate) ?: 1;
		$this->created  = $created ?? new DateTime;
	}

	public function getHome(): float { return (float) $this->home; }

	public function getRate(): float { return (float) $this->rate; }

	public function getCurrency(): Currency { return $this->currency; }

	public function getCreated(): DateTime { return $this->created; }
}
