<?php declare(strict_types = 1);

namespace Currency\Model\Entities;

use Core\Model\Entities\Country;
use Core\Model\Entities\Site;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("currency__currency")
 * @ORM\Entity
 * @ORM\EntityListeners({"Currency\Model\Listeners\CurrencyListener"})
 */
class Currency
{
	use TId;

	/**
	 * @ORM\Column(type="string", length=3, nullable=false)
	 */
	private string $code;

	/**
	 * @ORM\Column(type="string", length=10, nullable=false)
	 */
	public string $symbol;

	/**
	 * @var Country|null
	 * @ORM\OneToOne(targetEntity="Core\Model\Entities\Country")
	 * @ORM\JoinColumn(referencedColumnName="id", name="country", nullable=true, onDelete="SET NULL")
	 */
	public $country = null;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $title;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $nativeTitle;

	/**
	 * @var float
	 * @ORM\Column(name="home", type="decimal", precision=10, scale=5, nullable=false)
	 */
	public $home;

	/**
	 * @var float|string
	 * @ORM\Column(name="rate", type="decimal", precision=10, scale=5, nullable=false)
	 */
	public $rate;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(type="datetime")
	 */
	private $updated;

	/**
	 * @var Collection<CurrencyHistory>
	 * @ORM\OneToMany(targetEntity="CurrencyHistory", mappedBy="currency", orphanRemoval=true)
	 * @ORM\OrderBy({"created"="DESC"})
	 */
	private Collection $history;

	/**
	 * @var boolean
	 * @ORM\Column(type="boolean", nullable=true, options={"default": false})
	 */
	public $sync;

	/**
	 * @ORM\Column(type="string", nullable=true)
	 */
	public ?string $syncKey = null;

	/**
	 * @var Site|null
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", nullable=true, onDelete="SET NULL")
	 */
	public $site = null;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", length=1, nullable=false, options={"default": 0})
	 */
	public $currencyFromLeft;

	/**
	 * @var int
	 * @ORM\Column(type="integer", nullable=false, options={"default": 0})
	 */
	public $decimals;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", nullable=false, options={"default": 1})
	 */
	public $isActive;

	public function __construct(string $code, string $title, string $symbol, float $home, float $rate)
	{
		$this->code             = $code;
		$this->title            = $title;
		$this->symbol           = $symbol;
		$this->home             = $home;
		$this->rate             = $rate;
		$this->sync             = false;
		$this->history          = new ArrayCollection;
		$this->currencyFromLeft = 0;
		$this->decimals         = 0;
		$this->isActive         = 1;
	}

	public function getCode(): string { return $this->code; }

	public function getUpdated(): DateTime { return $this->updated; }

	/**
	 * @return Collection<CurrencyHistory>
	 */
	public function getHistory() { return $this->history; }
}
