<?php declare(strict_types = 1);

namespace Currency\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\UI\AbstractPresenter;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;
use Core\Model\Templating\Filters\Price as PriceFilter;

class PresenterSubscriber implements EventSubscriberInterface
{
	protected Currencies $currenciesService;
	protected PriceFilter $priceFilter;

	public function __construct(Currencies $currencies, PriceFilter $priceFilter)
	{
		$this->currenciesService = $currencies;
		$this->priceFilter       = $priceFilter;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			AbstractPresenter::class . '::startup' => 'startup',
		];
	}

	public function startup(ControlEvent $event): void
	{
	}
}
