<?php declare(strict_types = 1);

namespace Currency\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Core\Model\Event\TemplateFactoryEvent;
use Currency\Model\Currencies;
use Currency\Model\Exchange;

class TemplateFactorySubscriber implements EventSubscriberInterface
{
	protected Exchange $exchangeService;
	protected Currencies $currenciesService;

	public function __construct(Exchange $exchange, Currencies $currencies)
	{
		$this->exchangeService   = $exchange;
		$this->currenciesService = $currencies;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => ['createTemplate', 100],
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->exchangeService   = $this->exchangeService;
		$event->template->currency          = $this->currenciesService->getCurrent();
		$event->template->currenciesService = $this->currenciesService;
	}
}
