<?php declare(strict_types = 1);

namespace Currency\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TActive;
use Currency\Model\Entities\Currency;

/**
 * @method Currency[] getAll()
 * @method Currency|null get($id)
 * @method Currency getReference($id)
 */
class Currencies extends BaseEntityService
{
	use TActive;

	/** @var string */
	protected $entityClass = Currency::class;

	protected array $cByShop = [];

	/**
	 * @return Currency[]
	 */
	public function getByShop(string $shop): array
	{
		if (!isset($this->cByShop[$shop])) {
			$this->cByShop[$shop] = [];

			foreach ((array) $this->getEr()->createQueryBuilder('c')
				->where('c.site = :site')
				->setParameter('site', $shop)
				->getQuery()->getResult() as $row) {
				/** @var Currency $row */
				$this->cByShop[$shop][$row->getCode()] = $row;
			}
		}

		return $this->cByShop[$shop];
	}
}
