<?php declare(strict_types = 1);

namespace Currency\AdminModule\Model;

use Nette\Security\User;

class Security
{
	public const RESOURCE_CURRENCY = 'Currency:Admin';

	public function __construct(
		protected User $user,
	)
	{
	}

	public function access(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'access');
	}

	public function new(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'new');
	}

	public function edit(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'edit');
	}

	public function delete(): bool
	{
		return $this->user->isAllowed(self::RESOURCE_CURRENCY, 'delete');
	}
}
