<?php declare(strict_types = 1);

namespace Currency\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class CurrencyExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Currency' => 'Currency\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);

		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('Currency\Model\Config::setParams(?);', [$builder->parameters['currency']]);
		$init->addBody('$this->getService(\'currency.currencies\')->setDefaultCurrency();');
		$init->addBody('$this->getService(\'currency.currencies\')->setCurrencyByUrl();');
		$init->addBody('Core\Model\Templating\Filters\Price::$priceInitCallback[] = function($filter) { return $this->getService(\'currency.currencies\')->updatePriceFilter($filter); };');
	}
}
