<?php declare(strict_types = 1);

namespace Currency\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20191226213817 extends AbstractMigration
{
	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('ALTER TABLE currency__currency ADD site_id VARCHAR(255) DEFAULT NULL, ADD is_active TINYINT(1) NOT NULL DEFAULT \'1\'');
		$this->addSql('ALTER TABLE currency__currency_history DROP FOREIGN KEY FK_E9F57ECA38248176');
		$this->addSql('ALTER TABLE currency__currency ADD id INT AUTO_INCREMENT NOT NULL, DROP PRIMARY KEY, ADD PRIMARY KEY (id)');
		$this->addSql('ALTER TABLE currency__currency ADD CONSTRAINT FK_C318E4D7F6BD1646 FOREIGN KEY (site_id) REFERENCES core__site (ident) ON DELETE SET NULL');

		$this->addSql('TRUNCATE TABLE currency__currency_history');
		$this->addSql('ALTER TABLE currency__currency_history CHANGE currency_id currency_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE currency__currency_history ADD CONSTRAINT FK_E9F57ECA38248176 FOREIGN KEY (currency_id) REFERENCES currency__currency (id) ON DELETE CASCADE');

		$this->addSql('ALTER TABLE currency__currency ADD currency_from_left SMALLINT NOT NULL DEFAULT 0, ADD decimals INT NOT NULL DEFAULT 0');
		$this->addSql('CREATE INDEX IDX_C318E4D7F6BD1646 ON currency__currency (site_id)');
		$this->addSql("INSERT IGNORE INTO `currency__currency` (`id`, `code`, `country`, `symbol`, `title`, `native_title`, `home`, `rate`, `updated`, `sync`, `sync_key`, `site_id`, `currency_from_left`, `decimals`) VALUES (1, 'CZK', NULL, 'Kč', 'Koruna Česká', 'Koruna Česká', 1.000, 1.000, '2019-12-26 23:01:45', 1, 'ČNB', NULL, 0, 0)");
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE currency__currency DROP FOREIGN KEY FK_C318E4D7F6BD1646');
		$this->addSql('DROP INDEX IDX_C318E4D7F6BD1646 ON currency__currency');
		$this->addSql('ALTER TABLE currency__currency DROP site_id, DROP currency_from_left, DROP decimals, DROP is_active');

		$this->addSql('TRUNCATE TABLE currency__currency_history');
		$this->addSql('ALTER TABLE currency__currency DROP PRIMARY KEY');
		$this->addSql('ALTER TABLE currency__currency DROP column id');
		$this->addSql('ALTER TABLE currency__currency ADD PRIMARY KEY (code)');
		$this->addSql('ALTER TABLE currency__currency_history DROP FOREIGN KEY FK_E9F57ECA38248176');
		$this->addSql('ALTER TABLE currency__currency_history CHANGE currency_id currency_id VARCHAR(3) CHARACTER SET utf8 DEFAULT NULL COLLATE `utf8_unicode_ci`');
		$this->addSql('ALTER TABLE currency__currency_history ADD CONSTRAINT FK_E9F57ECA38248176 FOREIGN KEY (currency_id) REFERENCES currency__currency (code) ON DELETE CASCADE');
	}
}
