<?php declare(strict_types = 1);

namespace Currency\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use Core\Model\Templating\Filters\Price as PriceFilter;
use Core\Model\UI\AbstractPresenter;
use Currency\Model\Currencies;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class PresenterSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Currencies  $currenciesService,
		protected PriceFilter $priceFilter,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			AbstractPresenter::class . '::startup' => 'startup',
		];
	}

	public function startup(ControlEvent $event): void
	{
	}
}
