<?php declare(strict_types = 1);

namespace Currency\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use Currency\Model\Currencies;
use Currency\Model\Exchange;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateFactorySubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Exchange   $exchangeService,
		protected Currencies $currenciesService,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => ['createTemplate', 100],
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->exchangeService   = $this->exchangeService;
		$event->template->currency          = $this->currenciesService->getCurrent();
		$event->template->currenciesService = $this->currenciesService;
	}
}
