<?php declare(strict_types = 1);

namespace Currency\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Currency\Model\Currencies;
use Nette\Http\Request;
use Nette\Http\Url;

class CurrencySwitch extends BaseControl
{
	/** @var Currencies|null @inject */
	public ?Currencies $currenciesService = null;

	/** @var Request|null @inject */
	public ?Request $httpRequest;

	public function render(): void
	{
		$this->template->buildUrl   = function(string $curr): string {
			$urlString = $this->link('switch');
			$url       = new Url($urlString);

			return $url->setQueryParameter('curr', $curr)->getAbsoluteUrl();
		};
		$this->template->currencies = $this->getActiveCurrencies();
		$this->template->render($this->getTemplateFile());
	}

	public function handleSwitch(): void
	{
		$this->redirect('this');
	}

	public function getActiveCurrencies(): array
	{
		return $this->currenciesService->getActive();
	}
}
