<?php declare(strict_types = 1);

namespace Currency\Model\Driver;

use Exception;
use h4kuna\Exchange\Driver\Cnb\Day;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;

class Cnb extends Day
{
	protected function loadFromSource(?\DateTimeInterface $date): iterable
	{
		$dataFilePath = DATA_DIR . '/exchange/cnb.txt';
		try {
			$list = parent::loadFromSource($date);
		} catch (Exception $e) {
			$this->setDate('Y-m-d', ($date ?: new DateTime())->format('Y-m-d'));

			if (file_exists($dataFilePath)) {
				$list = json_decode(file_get_contents($dataFilePath), true);
			} else {
				$list = [
					"Česká Republika|koruna|1|CZK|1",
					"Austrálie|dolar|1|AUD|14.236",
					"Brazílie|real|1|BRL|3.895",
					"Bulharsko|lev|1|BGN|12.734",
					"Čína|žen-min-pi|1|CNY|3.020",
					"Dánsko|koruna|1|DKK|3.338",
					"EMU|euro|1|EUR|24.905",
					"Filipíny|peso|100|PHP|39.451",
					"Hongkong|dolar|1|HKD|2.833",
					"Indie|rupie|100|INR|26.046",
					"Indonesie|rupie|1000|IDR|1.336",
					"Island|koruna|100|ISK|16.977",
					"Izrael|nový šekel|1|ILS|6.072",
					"Japonsko|jen|100|JPY|15.263",
					"Jižní Afrika|rand|1|ZAR|1.200",
					"Kanada|dolar|1|CAD|15.906",
					"Korejská republika|won|100|KRW|1.599",
					"Maďarsko|forint|100|HUF|6.158",
					"Malajsie|ringgit|1|MYR|5.227",
					"Mexiko|peso|1|MXN|1.121",
					"MMF|ZPČ|1|XDR|29.728",
					"Norsko|koruna|1|NOK|2.113",
					"Nový Zéland|dolar|1|NZD|13.141",
					"Polsko|zlotý|1|PLN|5.828",
					"Rumunsko|leu|1|RON|5.002",
					"Singapur|dolar|1|SGD|17.034",
					"Švédsko|koruna|1|SEK|2.279",
					"Švýcarsko|frank|1|CHF|26.674",
					"Thajsko|baht|100|THB|66.731",
					"Turecko|lira|100|TRY|56.904",
					"USA|dolar|1|USD|21.955",
					"Velká Británie|libra|1|GBP|29.243",
				];
			}
		}

		@unlink($dataFilePath);
		FileSystem::createDir(dirname($dataFilePath));
		file_put_contents($dataFilePath, json_encode($list));

		return $list;
	}

}
