<?php declare(strict_types = 1);

namespace Currency\Model\Entities;

use Core\Model\Helpers\Strings;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("currency__currency_history")
 * @ORM\Entity
 */
class CurrencyHistory
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Currency", inversedBy="history")
	 * @ORM\JoinColumn(name="currency_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private ?Currency $currency = null;

	/**
	 * @var float
	 * @ORM\Column(type="decimal", precision=10, scale=3, nullable=false)
	 */
	private $home;

	/**
	 * @var float|string
	 * @ORM\Column(type="decimal", precision=10, scale=3, nullable=false)
	 */
	private $rate;

	/**
	 * @var DateTime
	 * @ORM\Column(type="datetime")
	 */
	private $created;

	public function __construct(Currency $currency, ?float $home = null, ?float $rate = null, ?DateTime $created = null)
	{
		$this->currency = $currency;
		$this->home     = $home ?: $currency->home;
		$this->rate     = Strings::formatEntityDecimal($rate ?: $currency->rate);
		$this->created  = $created ?? new DateTime;
	}

	public function getHome(): float { return $this->home; }

	public function getRate(): float { return $this->rate; }

	public function getCurrency(): Currency { return $this->currency; }

	public function getCreated(): DateTime { return $this->created; }
}
