<?php declare(strict_types = 1);

namespace Currency\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Currency\Model\Currencies;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\Model\Entities\Order;
use Core\Model\Templating\Filters\Price as PriceFilter;

class OrderSubscriber implements EventSubscriberInterface
{
	protected Currencies $currenciesService;
	protected PriceFilter $priceFilter;

	public function __construct(Currencies $currencies, PriceFilter $priceFilter)
	{
		$this->currenciesService = $currencies;
		$this->priceFilter       = $priceFilter;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			Order::class . '::postLoad' => ['postLoad', 100],
		];
	}

	public function postLoad(OrderEvent $event): void
	{
		$order = &$event->order;

		if (!$order->priceFilter) {
			$order->priceFilter = clone $this->priceFilter;
		}

		if ($order->currency) {
			$cur = $this->currenciesService->getAll()[$order->currency->code] ?? null;

			if ($cur !== null) {
				$order->priceFilter->format(0);
				$order->priceFilter->addOtherCurrency($order->currency->code, $cur->symbol, (bool) $cur->currencyFromLeft, $order->currency->decimals);
			}
		}
	}

}
