<?php declare(strict_types = 1);

namespace Currency\Model\Entities;

use Core\Model\Entities\Country;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("currency__currency")
 * @ORM\Entity
 */
class Currency
{
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(name="code", type="string", length=3, nullable=false, unique=true)
	 */
	protected $code;

	/**
	 * @var string
	 * @ORM\Column(name="symbol", type="string", length=10, nullable=false)
	 */
	public $symbol;

	/**
	 * @var Country
	 * @ORM\OneToOne(targetEntity="Core\Model\Entities\Country")
	 * @ORM\JoinColumn(referencedColumnName="id", name="country", nullable=true, onDelete="SET NULL")
	 */
	public $country;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="native_title", type="string", nullable=false)
	 */
	public $nativeTitle;

	/**
	 * @var decimal
	 * @ORM\Column(name="home", type="decimal", precision=10, scale=3, nullable=false)
	 */
	public $home;

	/**
	 * @var decimal
	 * @ORM\Column(name="rate", type="decimal", precision=10, scale=3, nullable=false)
	 */
	public $rate;

	/**
	 * @var DateTime
	 * @Gedmo\Timestampable(on="update")
	 * @ORM\Column(type="datetime")
	 */
	private $updated;

	/**
	 * @var CurrencyHistory[]
	 * @ORM\OneToMany(targetEntity="CurrencyHistory", mappedBy="currency", orphanRemoval=true)
	 * @ORM\OrderBy({"created"="DESC"})
	 */
	private $history;

	/**
	 * @var boolean
	 * @ORM\Column(name="sync", type="boolean", nullable=true, options={"default": false})
	 */
	public $sync;

	/**
	 * @var string
	 * @ORM\Column(name="sync_key", type="string", nullable=true)
	 */
	public $syncKey;

	public function __construct(string $code, string $title, string $symbol, float $home, float $rate)
	{
		$this->code    = $code;
		$this->title   = $title;
		$this->symbol  = $symbol;
		$this->home    = $home;
		$this->rate    = $rate;
		$this->sync    = false;
		$this->history = new ArrayCollection();
	}

	public function getUpdated(): DateTime { return $this->updated; }

	public function getHistory() { return $this->history; }
}
