<?php declare(strict_types = 1);

namespace Currency\Model\Entities;

use Core\Model\Entities\Country;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("currency__currency_history")
 * @ORM\Entity
 */
class CurrencyHistory
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var Currency
	 * @ORM\ManyToOne(targetEntity="Currency", inversedBy="history")
	 * @ORM\JoinColumn(name="currency_id", referencedColumnName="code", onDelete="CASCADE")
	 */
	private $currency;

	/**
	 * @var decimal
	 * @ORM\Column(name="home", type="decimal", precision=10, scale=3, nullable=false)
	 */
	private $home;

	/**
	 * @var decimal
	 * @ORM\Column(name="rate", type="decimal", precision=10, scale=3, nullable=false)
	 */
	private $rate;

	/**
	 * @var DateTime
	 * @ORM\Column(type="datetime")
	 */
	private $created;

	public function __construct(Currency $currency, ?float $home = null, ?float $rate = null, ?DateTime $created = null)
	{
		$this->currency = $currency;
		$this->home     = $home ?: $currency->home;
		$this->rate     = $rate ?: $currency->rate;
		$this->created  = $created ? $created : (new DateTime());
	}

	public function getHome(): float { return $this->home; }

	public function getRate(): float { return $this->rate; }

	public function getCurrency(): Currency { return $this->currency; }

	public function getCreated(): DateTime { return $this->created; }
}
