<?php declare(strict_types = 1);

namespace Dashboard\DI;

use Core\DI\CompilerExtension;
use Nette;

class DashboardExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Dashboard' => 'Dashboard\*Module\Presenters\*Presenter']);
	}

	public function getTranslationResources()
	{
		$resources   = parent::getTranslationResources();
		$resources[] = APP_DIR . '/langOverride';

		return $resources;
	}
}
