<?php declare(strict_types = 1);

namespace Dashboard\DI;

use Nette\DI\Definitions\ServiceDefinition;
use Core\DI\CompilerExtension;
use Nette;
use Override;

class DashboardExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Dashboard' => 'Dashboard\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$widgets = [];
		foreach ($builder->findByTag('dashboardWidget') as $def => $data) {
			$k           = explode('.', $def);
			$k           = $k[0] . ucfirst(end($k));
			$k           = str_replace('Factory', '', $k);
			$widgets[$k] = [
				'position' => $data['position'],
				'factory'  => $builder->getDefinition($def),
			];
		}

		uksort($widgets, static fn($a, $b) => $widgets[$a]['position'] <=> $widgets[$b]['position']);

		/** @var ServiceDefinition $def */
        $def = $builder->getDefinition('dashboard.admin.widgetsCollection');
		$def->addSetup('$service->addWidgets(?)', [$widgets]);
	}
}
