<?php declare(strict_types = 1);

namespace Dashboard\AdminModule\Model;

use Core\Model\UI\AbstractPresenter;
use Dashboard\AdminModule\Model\Provider\IWidget;

class WidgetsCollection
{
	/** @var array */
	protected $widgets;

	public function addWidgets(array $widgets): void
	{
		foreach ($widgets as $k => $widget)
			$this->widgets[$k] = $widget;
	}

	/** @return IWidget[] */
	public function getWidgets(AbstractPresenter $presenter): array
	{
		$widgets = [];

		foreach ($this->widgets as $name => $widget) {
			$w = $widget['factory']->create();
			$presenter->addComponent($w, $name);
			$widgets[] = $w;
		}

		return $widgets;
	}
}
