<?php declare(strict_types = 1);

namespace Dashboard\AdminModule\Presenters;

use Dashboard\AdminModule\Model\WidgetsCollection;

class DefaultPresenter extends BasePresenter
{
	/** @var WidgetsCollection @inject */
	public $widgetsCollection;

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		set_time_limit(360);
		ini_set('memory_limit', '5G');
		$this->setHeader('dashboard.title.adminSystem', 'fa fa-home');
		$this->template->widgets = $this->widgetsCollection->getWidgets($this);
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
}
