<?php declare(strict_types = 1);

namespace Dashboard\DI;

use Core\DI\CompilerExtension;
use Nette;

class DashboardExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Dashboard' => 'Dashboard\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$widgets = [];
		foreach ($builder->findByTag('dashboardWidget') as $def => $data) {
			$k           = explode('.', $def);
			$k           = $k[0] . ucfirst(end($k));
			$k           = str_replace('Factory', '', $k);
			$widgets[$k] = [
				'position' => $data['position'],
				'factory'  => $builder->getDefinition($def),
			];
		}

		uksort($widgets, function($a, $b) use ($widgets) {
			return $widgets[$a]['position'] <=> $widgets[$b]['position'];
		});

		/** @var Nette\DI\Definitions\ServiceDefinition $def */
		$def = $builder->getDefinition('dashboard.admin.widgetsCollection');
		$def->addSetup('$service->addWidgets(?)', [$widgets]);
	}
}
