<?php declare(strict_types=1);

namespace DynamicModule\AdminModule\Components;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use DynamicModule\AdminModule\Model\Events\GroupEvent;
use DynamicModule\Model\Entities\Group;
use DynamicModule\Model\Entities\GroupMember;
use DynamicModule\Model\Repository\GroupMembers;
use DynamicModule\Model\Repository\Groups;
use DynamicModule\Model\Repository\Members;
use Nette\Caching\Cache;

class GroupDetail extends BaseControl
{
	/** @var Group|null */
	protected ?Group $group;
	
	/** @var GroupMembers */
	protected GroupMembers $groupMembers;

	/** @var Members */
	protected Members $members;

	/**
	 * GroupDetail constructor.
	 * @param GroupMembers $groupMembers
	 * @param Members $members
	 */
	public function __construct(GroupMembers $groupMembers, Members $members)
	{
		$this->groupMembers = $groupMembers;
		$this->members = $members;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return BaseDataGrid
	 */
	public function createComponentGrid(): BaseDataGrid
	{
		EntityManagerDecorator::$useDoctrineQuery = true;
		$qb = $this->members->getQueryBuilderByGroup($this->group->getId());
		
		$grid = $this->createGrid();
		$grid->setDataSource($qb)
			 ->setSortable()
			 ->setSortableHandler('groupsGrid:groupDetail:sort!');
		
		$grid->addColumnText('title', 'default.title')
			 ->setRenderer(static function (GroupMember $groupMember): string {
			 	return $groupMember->member->title;
			 });
		
		return $grid;
	}

	/**
	 * @param Group $group
	 */
	public function setGroup(Group $group): void
	{
		$this->group = $group;
	}

	public function handleSort(): void
	{
		$presenter = $this->getPresenter();
		$request = $presenter->getHttpRequest();
		$groupMemberId = $request->getPost('id', null);
		$position = $request->getPost('position', null);
		$groupMember = $this->groupMembers->get((int) $groupMemberId);

		if ($groupMemberId != null && $position != null && $groupMember !== null) {
			$groupMember->position = (int) $position;
			$this->em->persist($groupMember);
			$this->em->flush();
			$presenter->flashMessageSuccess('default.positionChanged');
			$group = $groupMember->group;
			$this->eventDispatcher->dispatch(new GroupEvent($group), 'dynamicModule.admin.' . $group->moduleKey . '.groupChanged');

			$cache = new Cache($this->cacheStorage, \DynamicModule\FrontModule\Model\Repository\Groups::CACHE_NAMESPACE);
			$cache->clean([Cache::TAGS => [\DynamicModule\FrontModule\Model\Repository\Groups::CACHE_NAMESPACE]]);
		} else {
			$presenter->flashMessageDanger('default.positionChangeFailed');
		}

		$presenter->redrawControl('flashes');
	}

}
