<?php declare(strict_types = 1);

namespace DynamicModule\AdminModule\Presenters;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		$moduleKey = $this->getParameter('id');
		if (!$moduleKey || !$this->getUser()->isAllowed($this->getFullModuleName() . ':' . ucfirst($moduleKey), 'access'))
			$this->error();
	}
}